//-----------------------------------------------------------------
//-----------------------------------------------------------------
#property copyright "www.forex-station.com"
#property link      "www.forex-station.com"

#property indicator_separate_window
#property indicator_buffers 2
#property indicator_minimum 0
#property indicator_maximum 1

extern ENUM_APPLIED_PRICE Price        = PRICE_WEIGHTED;  // Price to use
extern double             K            = 1;               // Filter
extern double             Sharpness    = 1;               // Sharpness
input int                 HistoWidth   = 3;               // Histogram bars width
input color               UpHistoColor = clrLimeGreen;    // Up histogram color
input color               DnHistoColor = clrRed;          // Down histogram color

double val[],valda[],valdb[],state[],vel[];

//------------------------------------------------------------------
//
//------------------------------------------------------------------
//
//
//
//
//

int init()
{
   IndicatorBuffers(5);
   SetIndexBuffer(0,valda); SetIndexStyle(0, DRAW_HISTOGRAM,EMPTY,HistoWidth,UpHistoColor);
   SetIndexBuffer(1,valdb); SetIndexStyle(1, DRAW_HISTOGRAM,EMPTY,HistoWidth,DnHistoColor);
   SetIndexBuffer(2,vel);
   SetIndexBuffer(3,state);
   SetIndexBuffer(4,val);
   return(0);
}
int start()
{
   int counted_bars = IndicatorCounted();
      if(counted_bars < 0) return(-1);
      if(counted_bars > 0) counted_bars--;
           int limit = fmin(Bars-counted_bars,Bars-1);
           
   //
   //
   //
   //
   //
   
 	for(int i = limit; i>=0; i--) 
 	{
      double price = iMA(NULL,0,1,0,MODE_SMA,Price,i);
      if (i>=(Bars-1)) { vel[i] = 0; val[i] = price; continue; }
         double distance   = price - val[i+1];
         double error      = val[i+1] + distance * sqrt(Sharpness*K/100);
                  vel[i]   = vel[i+1] + distance*K/100;
                  val[i]   = error+vel[i];
                  state[i] = (i<Bars-1) ? (vel[i]>0)  ? 1 : (vel[i]<0)  ? -1 : state[i+1] : 0;  
                  valda[i] = (state[i] == 1) ? 1 : EMPTY_VALUE;
                  valdb[i] = (state[i] ==-1) ? 1 : EMPTY_VALUE;   
                  
   }
   return(0);
}

